*-------------------------------------------------------------------------------
*					Table 3
*-------------------------------------------------------------------------------

** Set Path
global Raw_data    	"G:\project-finished\Descriptive\Data"
global App_data    	"G:\project-finished\Descriptive\Appendix Data"
global Class_data   "G:\project-finished\Descriptive\Classification"  
global Work_lab   	"G:\project-finished\Descriptive\Lab"
global Out_lab    	"G:\project-finished\Descriptive\Out" 

cd "$Work_lab"
                            
capture log close            
log using "$Out_lab\Tab 3", replace 
set more off     


*-------------------------------------------------------------------------------
*					Step1: Generate Data
*-------------------------------------------------------------------------------
clear
clear all

//empty file for processed data
set obs 0
save tabledata,replace emptyok


foreach j in "2000" "2010" "2015" {
use "`j'census_consistent.dta",clear

*Define edu group
	if `j'==2000{
	tostring educ,gen(edu_level) 

	gen edu=1 if edu_level=="1"|edu_level=="2"|edu_level=="3"|edu_level=="4" 
	replace edu=2 if edu_level=="5" |edu_level=="6"
	replace edu=3 if edu_level=="7" |edu_level=="8" | edu_level=="9"
	}

	if `j'==2010{
	tostring _受教育程度,gen(edu_level) 
	
	gen edu=1 if edu_level=="1"|edu_level=="2"|edu_level=="3"
	replace edu=2 if edu_level=="4" 
	replace edu=3 if edu_level=="5" |edu_level=="6" | edu_level=="7"
	}

	if `j'==2015{
	gen edu=1 if edu_level=="1"|edu_level=="2"|edu_level=="3"
	replace edu=2 if edu_level=="4" |edu_level=="5"
	replace edu=3 if edu_level=="6" |edu_level=="7" | edu_level=="8"
	}

*Define education requirement group
//In usa, less than 10 years: low, 12-13: medium, 14-20:high
drop if education==.

gen required=1 if education<12
replace required=2 if education>=12&education<14
replace required=3 if education>=14

gen id_new=_n

collapse (count) id_new,by(edu required)
bys required:egen temp=total(id_new)
gen share=(id_new/temp)*100
keep edu required share
duplicates drop

gen year=`j'
append using tabledata
save tabledata,replace
}

*-------------------------------------------------------------------------------
*					Step2: Display
*-------------------------------------------------------------------------------
reshape wide share,i(required year) j(edu)
format share* %6.2f

list _all


erase tabledata.dta
log close








